/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.link.L2tpLink;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;

public class TestL2tpAttLink
extends L2tpLink {
    private static final String TRACE_MASKT = "XRCSLALT";
    private static final String TRACE_MASKF = "XRCSLALF";
    private static final String TRACE_MASKD = "XRCSLALD";
    private static TestL2tpAttLink instance;

    protected TestL2tpAttLink() {
        this.maxOpenPaths = 1;
        Trace.trace(TRACE_MASKT, "<-> L2tpAttLink()");
    }

    public static RcsLink getInstance() {
        if (instance == null) {
            instance = new TestL2tpAttLink();
        }
        Trace.trace(TRACE_MASKT, "<-> getInstance() [" + instance + "]");
        return instance;
    }

    public void activate() throws LinkAlreadyActiveException, LinkFailedException, LinkNotConfiguredException {
        Trace.trace(TRACE_MASKT, "--> activate()");
        if (this.active) {
            throw new LinkAlreadyActiveException();
        }
        if (!this.isConfigured()) {
            throw new LinkNotConfiguredException();
        }
        try {
            int rc = 0;
            OutboundConfigData outConfig = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
            rc = RcsControl.startRemDial();
            if (rc != 0) {
                this.active = false;
                throw new LinkFailedException("Failed to remote dial (RC: " + rc + ")");
            }
            rc = RcsControl.startVpn();
            if (rc != 0) {
                this.active = false;
                RcsControl.stopDial();
                throw new LinkFailedException("Failed to start VPN (RC: " + rc + ")");
            }
            this.active = true;
        }
        catch (LinkFailedException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- activate()");
    }

    public void deactivate() {
        Trace.trace(TRACE_MASKT, "--> deactivate()");
        try {
            RcsControl.stopVpn();
            RcsControl.stopRemDial();
            this.active = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- deactivate()");
    }

    public boolean isConfigured() {
        OutboundConfigData data = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        boolean configured = true;
        Trace.trace(TRACE_MASKT, "<-> isConfigured() [" + configured + "]");
        return configured;
    }
}

